/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdfparser;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNull;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.exceptions.CryptographyException;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.io.PushBackInputStream;
import org.apache.pdfbox.io.RandomAccess;
import org.apache.pdfbox.io.RandomAccessBuffer;
import org.apache.pdfbox.io.RandomAccessBufferedFileInputStream;
import org.apache.pdfbox.pdfparser.EndstreamOutputStream;
import org.apache.pdfbox.pdfparser.PDFObjectStreamParser;
import org.apache.pdfbox.pdfparser.PDFParser;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.encryption.AccessPermission;
import org.apache.pdfbox.pdmodel.encryption.DecryptionMaterial;
import org.apache.pdfbox.pdmodel.encryption.PDEncryptionDictionary;
import org.apache.pdfbox.pdmodel.encryption.PublicKeyDecryptionMaterial;
import org.apache.pdfbox.pdmodel.encryption.SecurityHandler;
import org.apache.pdfbox.pdmodel.encryption.SecurityHandlersManager;
import org.apache.pdfbox.pdmodel.encryption.StandardDecryptionMaterial;
import org.apache.pdfbox.persistence.util.COSObjectKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NonSequentialPDFParser
extends PDFParser {
    private static final byte[] XREF_TABLE = new byte[]{120, 114, 101, 102};
    private static final byte[] XREF_STREAM = new byte[]{47, 88, 82, 101, 102};
    private static final long MINIMUM_SEARCH_OFFSET = 6L;
    private static final int X = 120;
    public static final String SYSPROP_PARSEMINIMAL = "org.apache.pdfbox.pdfparser.nonSequentialPDFParser.parseMinimal";
    public static final String SYSPROP_EOFLOOKUPRANGE = "org.apache.pdfbox.pdfparser.nonSequentialPDFParser.eofLookupRange";
    private static final InputStream EMPTY_INPUT_STREAM = new ByteArrayInputStream(new byte[0]);
    protected static final int DEFAULT_TRAIL_BYTECOUNT = 2048;
    protected static final char[] EOF_MARKER = new char[]{'%', '%', 'E', 'O', 'F'};
    protected static final char[] STARTXREF_MARKER = new char[]{'s', 't', 'a', 'r', 't', 'x', 'r', 'e', 'f'};
    protected static final char[] OBJ_MARKER = new char[]{'o', 'b', 'j'};
    private static final char[] TRAILER_MARKER = new char[]{'t', 'r', 'a', 'i', 'l', 'e', 'r'};
    private long trailerOffset;
    private final File pdfFile;
    private long fileLen;
    private final RandomAccessBufferedFileInputStream raStream;
    private boolean isLenient = true;
    private HashMap<String, Long> bfSearchObjectOffsets = null;
    private HashMap<COSObjectKey, Long> bfSearchCOSObjectKeyOffsets = null;
    private Vector<Long> bfSearchXRefOffsets = null;
    protected SecurityHandler securityHandler = null;
    private String keyStoreFilename = null;
    private String alias = null;
    private String password = "";
    private int readTrailBytes = 2048;
    private boolean parseMinimalCatalog = "true".equals(System.getProperty("org.apache.pdfbox.pdfparser.nonSequentialPDFParser.parseMinimal"));
    private boolean initialParseDone = false;
    private boolean allPagesParsed = false;
    private static final Log LOG = LogFactory.getLog(NonSequentialPDFParser.class);
    private boolean isTmpPDFFile = false;
    public static final String TMP_FILE_PREFIX = "tmpPDF";
    private COSDictionary pagesDictionary = null;
    private boolean inGetLength = false;
    private final int streamCopyBufLen = 8192;
    private final byte[] streamCopyBuf = new byte[8192];

    public NonSequentialPDFParser(String filename) throws IOException {
        this(new File(filename), null);
    }

    public NonSequentialPDFParser(File file, RandomAccess raBuf) throws IOException {
        this(file, raBuf, "");
    }

    public NonSequentialPDFParser(File file, RandomAccess raBuf, String decryptionPassword) throws IOException {
        super(EMPTY_INPUT_STREAM, null, false);
        this.pdfFile = file;
        this.raStream = new RandomAccessBufferedFileInputStream(this.pdfFile);
        this.init(file, raBuf, decryptionPassword);
    }

    private void init(File file, RandomAccess raBuf, String decryptionPassword) throws IOException {
        String eofLookupRangeStr = System.getProperty(SYSPROP_EOFLOOKUPRANGE);
        if (eofLookupRangeStr != null) {
            try {
                this.setEOFLookupRange(Integer.parseInt(eofLookupRangeStr));
            }
            catch (NumberFormatException nfe) {
                LOG.warn((Object)("System property org.apache.pdfbox.pdfparser.nonSequentialPDFParser.eofLookupRange does not contain an integer value, but: '" + eofLookupRangeStr + "'"));
            }
        }
        this.setDocument(raBuf == null ? new COSDocument(new RandomAccessBuffer(), false) : new COSDocument(raBuf, false));
        this.pdfSource = new PushBackInputStream(this.raStream, 4096);
        this.password = decryptionPassword;
    }

    public NonSequentialPDFParser(InputStream input) throws IOException {
        this(input, null, "");
    }

    public NonSequentialPDFParser(InputStream input, RandomAccess raBuf, String decryptionPassword) throws IOException {
        super(EMPTY_INPUT_STREAM, null, false);
        this.pdfFile = this.createTmpFile(input);
        this.raStream = new RandomAccessBufferedFileInputStream(this.pdfFile);
        this.init(this.pdfFile, raBuf, decryptionPassword);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createTmpFile(InputStream input) throws IOException {
        File file;
        File tmpFile = null;
        FileOutputStream fos = null;
        try {
            tmpFile = File.createTempFile(TMP_FILE_PREFIX, ".pdf");
            fos = new FileOutputStream(tmpFile);
            IOUtils.copy(input, fos);
            this.isTmpPDFFile = true;
            file = tmpFile;
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            IOUtils.closeQuietly(input);
            IOUtils.closeQuietly(fos);
            throw throwable;
        }
        IOUtils.closeQuietly(input);
        IOUtils.closeQuietly(fos);
        return file;
    }

    public void setEOFLookupRange(int byteCount) {
        if (byteCount > 15) {
            this.readTrailBytes = byteCount;
        }
    }

    protected void initialParse() throws IOException {
        COSObject catalogObj;
        COSDictionary trailer = null;
        long startXRefOffset = this.getStartxrefOffset();
        if (startXRefOffset > 0L) {
            trailer = this.parseXref(startXRefOffset);
        } else if (this.isFDFDocment || this.isLenient) {
            this.xrefTrailerResolver.nextXrefObj(startXRefOffset);
            this.bfSearchForObjects();
            for (COSObjectKey objectKey : this.bfSearchCOSObjectKeyOffsets.keySet()) {
                this.xrefTrailerResolver.setXRef(objectKey, this.bfSearchCOSObjectKeyOffsets.get(objectKey));
            }
            this.pdfSource.seek(this.trailerOffset);
            if (!this.parseTrailer()) {
                throw new IOException("Expected trailer object at position: " + this.pdfSource.getOffset());
            }
            this.xrefTrailerResolver.setStartxref(startXRefOffset);
            trailer = this.xrefTrailerResolver.getCurrentTrailer();
            this.document.setTrailer(trailer);
        }
        this.prepareDecryption();
        for (COSBase trailerEntry : trailer.getValues()) {
            if (!(trailerEntry instanceof COSObject)) continue;
            COSObject tmpObj = (COSObject)trailerEntry;
            this.parseObjectDynamically(tmpObj, false);
        }
        COSObject root = (COSObject)this.xrefTrailerResolver.getTrailer().getItem(COSName.ROOT);
        if (root == null) {
            throw new IOException("Missing root object specification in trailer.");
        }
        COSBase rootObject = this.parseObjectDynamically(root, false);
        if (this.isFDFDocment) {
            if (rootObject instanceof COSDictionary) {
                this.parseDictObjects((COSDictionary)rootObject, null);
                this.allPagesParsed = true;
                this.document.setDecrypted();
            }
        } else if (!this.parseMinimalCatalog && (catalogObj = this.document.getCatalog()) != null && catalogObj.getObject() instanceof COSDictionary) {
            this.parseDictObjects((COSDictionary)catalogObj.getObject(), null);
            this.allPagesParsed = true;
            this.document.setDecrypted();
        }
        this.readVersionInTrailer(trailer);
        this.initialParseDone = true;
    }

    private void parseDictionaryRecursive(COSObject dictionaryObject) throws IOException {
        this.parseObjectDynamically(dictionaryObject, true);
        COSDictionary dictionary = (COSDictionary)dictionaryObject.getObject();
        for (COSBase value : dictionary.getValues()) {
            COSObject object;
            if (!(value instanceof COSObject) || (object = (COSObject)value).getObject() != null) continue;
            this.parseDictionaryRecursive(object);
        }
    }

    private void prepareDecryption() throws IOException {
        COSBase trailerEncryptItem = this.document.getTrailer().getItem(COSName.ENCRYPT);
        if (trailerEncryptItem != null && !(trailerEncryptItem instanceof COSNull)) {
            if (trailerEncryptItem instanceof COSObject) {
                COSObject trailerEncryptObj = (COSObject)trailerEncryptItem;
                this.parseDictionaryRecursive(trailerEncryptObj);
            }
            try {
                PDEncryptionDictionary encParameters = new PDEncryptionDictionary(this.document.getEncryptionDictionary());
                DecryptionMaterial decryptionMaterial = null;
                if (this.keyStoreFilename != null) {
                    KeyStore ks = KeyStore.getInstance("PKCS12");
                    ks.load(new FileInputStream(this.keyStoreFilename), this.password.toCharArray());
                    decryptionMaterial = new PublicKeyDecryptionMaterial(ks, this.alias, this.password);
                } else {
                    decryptionMaterial = new StandardDecryptionMaterial(this.password);
                }
                this.securityHandler = SecurityHandlersManager.getInstance().getSecurityHandler(encParameters.getFilter());
                this.securityHandler.prepareForDecryption(encParameters, this.document.getDocumentID(), decryptionMaterial);
                AccessPermission permission = this.securityHandler.getCurrentAccessPermission();
                if (!permission.canExtractContent()) {
                    LOG.warn((Object)("PDF file '" + this.pdfFile.getPath() + "' does not allow extracting content."));
                }
            }
            catch (Exception e) {
                throw new IOException("Error (" + e.getClass().getSimpleName() + ") while creating security handler for decryption: " + e.getMessage());
            }
        }
    }

    private COSDictionary parseXref(long startXRefOffset) throws IOException {
        COSDictionary trailer;
        this.setPdfSource(startXRefOffset);
        this.parseStartXref();
        long startXrefOffset = this.document.getStartXref();
        long fixedOffset = this.checkXRefOffset(startXrefOffset);
        if (fixedOffset > -1L) {
            startXrefOffset = fixedOffset;
            this.document.setStartXref(startXrefOffset);
        }
        long prev = startXrefOffset;
        while (prev > -1L) {
            this.setPdfSource(prev);
            this.skipSpaces();
            if (this.pdfSource.peek() == 120) {
                this.parseXrefTable(prev);
                this.trailerOffset = this.pdfSource.getOffset();
                while (this.isLenient && this.pdfSource.peek() != 116) {
                    if (this.pdfSource.getOffset() == this.trailerOffset) {
                        LOG.warn((Object)("Expected trailer object at position " + this.trailerOffset + ", keep trying"));
                    }
                    this.readLine();
                }
                if (!this.parseTrailer()) {
                    throw new IOException("Expected trailer object at position: " + this.pdfSource.getOffset());
                }
                trailer = this.xrefTrailerResolver.getCurrentTrailer();
                if (trailer.containsKey(COSName.XREF_STM)) {
                    int streamOffset = trailer.getInt(COSName.XREF_STM);
                    fixedOffset = this.checkXRefOffset(streamOffset);
                    if (fixedOffset > -1L && fixedOffset != (long)streamOffset) {
                        streamOffset = (int)fixedOffset;
                        trailer.setInt(COSName.XREF_STM, streamOffset);
                    }
                    this.setPdfSource(streamOffset);
                    this.skipSpaces();
                    this.parseXrefObjStream(prev, false);
                }
                if ((prev = (long)trailer.getInt(COSName.PREV)) <= -1L || (fixedOffset = this.checkXRefOffset(prev)) <= -1L || fixedOffset == prev) continue;
                prev = fixedOffset;
                trailer.setLong(COSName.PREV, prev);
                continue;
            }
            if ((prev = this.parseXrefObjStream(prev, true)) <= -1L || (fixedOffset = this.checkXRefOffset(prev)) <= -1L || fixedOffset == prev) continue;
            prev = fixedOffset;
            trailer = this.xrefTrailerResolver.getCurrentTrailer();
            trailer.setLong(COSName.PREV, prev);
        }
        this.xrefTrailerResolver.setStartxref(startXrefOffset);
        trailer = this.xrefTrailerResolver.getTrailer();
        this.document.setTrailer(trailer);
        this.checkXrefOffsets();
        return trailer;
    }

    private long parseXrefObjStream(long objByteOffset, boolean isStandalone) throws IOException {
        this.readObjectNumber();
        this.readGenerationNumber();
        this.readPattern(OBJ_MARKER);
        COSDictionary dict = this.parseCOSDictionary();
        COSStream xrefStream = this.parseCOSStream(dict, this.getDocument().getScratchFile());
        this.parseXrefStream(xrefStream, (int)objByteOffset, isStandalone);
        return dict.getLong(COSName.PREV);
    }

    private final long getPdfSourceOffset() {
        return this.pdfSource.getOffset();
    }

    protected final void setPdfSource(long fileOffset) throws IOException {
        this.pdfSource.seek(fileOffset);
    }

    protected final void releasePdfSourceInputStream() throws IOException {
    }

    private final void closeFileStream() throws IOException {
        if (this.pdfSource != null) {
            this.pdfSource.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final long getStartxrefOffset() throws IOException {
        int bufOff;
        long skipBytes;
        byte[] buf;
        block7: {
            this.fileLen = this.pdfFile.length();
            FileInputStream fIn = null;
            try {
                int readBytes;
                fIn = new FileInputStream(this.pdfFile);
                int trailByteCount = this.fileLen < (long)this.readTrailBytes ? (int)this.fileLen : this.readTrailBytes;
                buf = new byte[trailByteCount];
                skipBytes = this.fileLen - (long)trailByteCount;
                fIn.skip(skipBytes);
                for (int off = 0; off < trailByteCount; off += readBytes) {
                    readBytes = fIn.read(buf, off, trailByteCount - off);
                    if (readBytes >= 1) continue;
                    throw new IOException("No more bytes to read for trailing buffer, but expected: " + (trailByteCount - off));
                }
                Object var9_7 = null;
                if (fIn == null) break block7;
            }
            catch (Throwable throwable) {
                Object var9_8 = null;
                if (fIn == null) throw throwable;
                try {
                    fIn.close();
                    throw throwable;
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException ioe) {}
            fIn.close();
        }
        if ((bufOff = this.lastIndexOf(EOF_MARKER, buf, buf.length)) < 0) {
            if (!this.isLenient) throw new IOException("Missing end of file marker '" + new String(EOF_MARKER) + "'");
            bufOff = buf.length;
            LOG.debug((Object)("Missing end of file marker '" + new String(EOF_MARKER) + "'"));
        }
        if ((bufOff = this.lastIndexOf(STARTXREF_MARKER, buf, bufOff)) >= 0) return skipBytes + (long)bufOff;
        if (!this.isLenient) throw new IOException("Missing 'startxref' marker.");
        this.trailerOffset = this.lastIndexOf(TRAILER_MARKER, buf, buf.length);
        if (this.trailerOffset <= 0L) return -1L;
        this.trailerOffset += skipBytes;
        return -1L;
    }

    protected int lastIndexOf(char[] pattern, byte[] buf, int endOff) {
        int lastPatternChOff = pattern.length - 1;
        int bufOff = endOff;
        int patOff = lastPatternChOff;
        char lookupCh = pattern[patOff];
        while (--bufOff >= 0) {
            if (buf[bufOff] == lookupCh) {
                if (--patOff < 0) {
                    return bufOff;
                }
                lookupCh = pattern[patOff];
                continue;
            }
            if (patOff >= lastPatternChOff) continue;
            patOff = lastPatternChOff;
            lookupCh = pattern[patOff];
        }
        return -1;
    }

    protected final void readPattern(char[] pattern) throws IOException {
        this.skipSpaces();
        for (char c : pattern) {
            if (this.pdfSource.read() == c) continue;
            throw new IOException("Expected pattern '" + new String(pattern) + "' but missed at character '" + c + "' at offset " + this.pdfSource.getOffset());
        }
        this.skipSpaces();
    }

    private COSDictionary getPagesObject() throws IOException {
        if (this.pagesDictionary != null) {
            return this.pagesDictionary;
        }
        COSObject pages = (COSObject)this.document.getCatalog().getItem(COSName.PAGES);
        if (pages == null) {
            throw new IOException("Missing PAGES entry in document catalog.");
        }
        COSBase object = this.parseObjectDynamically(pages, false);
        if (!(object instanceof COSDictionary)) {
            throw new IOException("PAGES not a dictionary object, but: " + object.getClass().getSimpleName());
        }
        this.pagesDictionary = (COSDictionary)object;
        return this.pagesDictionary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parse() throws IOException {
        boolean exceptionOccurred = true;
        try {
            this.parseHeader();
            this.pdfSource.seek(0L);
            if (!this.initialParseDone) {
                this.initialParse();
            }
            if (!this.isFDFDocment) {
                int pageCount = this.getPageNumber();
                if (!this.allPagesParsed) {
                    for (int pNr = 0; pNr < pageCount; ++pNr) {
                        this.getPage(pNr);
                    }
                    this.allPagesParsed = true;
                    this.document.setDecrypted();
                }
            }
            exceptionOccurred = false;
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                this.closeFileStream();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            this.deleteTempFile();
            if (exceptionOccurred && this.document != null) {
                try {
                    this.document.close();
                    this.document = null;
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
            throw throwable;
        }
        try {
            this.closeFileStream();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        this.deleteTempFile();
        if (exceptionOccurred && this.document != null) {
            try {
                this.document.close();
                this.document = null;
            }
            catch (IOException ioe) {}
        }
    }

    protected File getPdfFile() {
        return this.pdfFile;
    }

    public boolean isLenient() {
        return this.isLenient;
    }

    public void setLenient(boolean lenient) throws IllegalArgumentException {
        if (this.initialParseDone) {
            throw new IllegalArgumentException("Cannot change leniency after parsing");
        }
        this.isLenient = lenient;
    }

    protected void deleteTempFile() {
        if (this.isTmpPDFFile) {
            try {
                if (!this.pdfFile.delete()) {
                    LOG.warn((Object)("Temporary file '" + this.pdfFile.getName() + "' can't be deleted"));
                }
            }
            catch (SecurityException e) {
                LOG.warn((Object)("Temporary file '" + this.pdfFile.getName() + "' can't be deleted"), (Throwable)e);
            }
        }
    }

    public SecurityHandler getSecurityHandler() {
        return this.securityHandler;
    }

    @Override
    public PDDocument getPDDocument() throws IOException {
        PDDocument pdDocument = super.getPDDocument();
        if (this.securityHandler != null) {
            pdDocument.setSecurityHandler(this.securityHandler);
        }
        return pdDocument;
    }

    public int getPageNumber() throws IOException {
        int pageCount = this.getPagesObject().getInt(COSName.COUNT);
        if (pageCount < 0) {
            throw new IOException("No page number specified.");
        }
        return pageCount;
    }

    public PDPage getPage(int pageNr) throws IOException {
        this.getPagesObject();
        COSArray kids = (COSArray)this.pagesDictionary.getDictionaryObject(COSName.KIDS);
        if (kids == null) {
            throw new IOException("Missing 'Kids' entry in pages dictionary.");
        }
        COSObject pageObj = this.getPageObject(pageNr, kids, 0);
        if (pageObj == null) {
            throw new IOException("Page " + pageNr + " not found.");
        }
        COSDictionary pageDict = (COSDictionary)pageObj.getObject();
        if (this.parseMinimalCatalog && !this.allPagesParsed) {
            this.parseDictObjects(pageDict, new COSName[0]);
        }
        return new PDPage(pageDict);
    }

    private COSObject getPageObject(int num, COSArray startKids, int startPageCount) throws IOException {
        int curPageCount = startPageCount;
        for (COSObject obj : startKids) {
            COSDictionary dic;
            int count;
            COSBase base = obj.getObject();
            if (base == null) {
                base = this.parseObjectDynamically(obj, false);
                obj.setObject(base);
            }
            if ((count = (dic = (COSDictionary)base).getInt(COSName.COUNT)) >= 0 && curPageCount + count <= num) {
                curPageCount += count;
                continue;
            }
            COSArray kids = (COSArray)dic.getDictionaryObject(COSName.KIDS);
            if (kids != null) {
                COSObject ans = this.getPageObject(num, kids, curPageCount);
                if (ans == null) continue;
                return ans;
            }
            if (curPageCount == num) {
                return obj;
            }
            ++curPageCount;
        }
        return null;
    }

    private final long getObjectId(COSObject obj) {
        return obj.getObjectNumber().longValue() << 32 | obj.getGenerationNumber().longValue();
    }

    private final void addNewToList(Queue<COSBase> toBeParsedList, Collection<COSBase> newObjects, Set<Long> addedObjects) {
        for (COSBase newObject : newObjects) {
            long objId;
            if (newObject instanceof COSObject && !addedObjects.add(objId = this.getObjectId((COSObject)newObject))) continue;
            toBeParsedList.add(newObject);
        }
    }

    private final void addNewToList(Queue<COSBase> toBeParsedList, COSBase newObject, Set<Long> addedObjects) {
        long objId;
        if (newObject instanceof COSObject && !addedObjects.add(objId = this.getObjectId((COSObject)newObject))) {
            return;
        }
        toBeParsedList.add(newObject);
    }

    private void parseDictObjects(COSDictionary dict, COSName ... excludeObjects) throws IOException {
        LinkedList<COSBase> toBeParsedList = new LinkedList<COSBase>();
        TreeMap<Long, List<COSObject>> objToBeParsed = new TreeMap<Long, List<COSObject>>();
        HashSet<Long> parsedObjects = new HashSet<Long>();
        HashSet<Long> addedObjects = new HashSet<Long>();
        if (excludeObjects != null) {
            for (COSName objName : excludeObjects) {
                COSBase baseObj = dict.getItem(objName);
                if (!(baseObj instanceof COSObject)) continue;
                parsedObjects.add(this.getObjectId((COSObject)baseObj));
            }
        }
        this.addNewToList(toBeParsedList, dict.getValues(), addedObjects);
        while (!toBeParsedList.isEmpty() || !objToBeParsed.isEmpty()) {
            COSBase baseObj;
            while ((baseObj = (COSBase)toBeParsedList.poll()) != null) {
                if (baseObj instanceof COSStream) {
                    this.addNewToList(toBeParsedList, ((COSStream)baseObj).getValues(), addedObjects);
                    continue;
                }
                if (baseObj instanceof COSDictionary) {
                    this.addNewToList(toBeParsedList, ((COSDictionary)baseObj).getValues(), addedObjects);
                    continue;
                }
                if (baseObj instanceof COSArray) {
                    Iterator<COSBase> arrIter = ((COSArray)baseObj).iterator();
                    while (arrIter.hasNext()) {
                        this.addNewToList(toBeParsedList, arrIter.next(), addedObjects);
                    }
                    continue;
                }
                if (!(baseObj instanceof COSObject)) continue;
                COSObject obj = (COSObject)baseObj;
                long objId = this.getObjectId(obj);
                COSObjectKey objKey = new COSObjectKey(obj.getObjectNumber().intValue(), obj.getGenerationNumber().intValue());
                if (parsedObjects.contains(objId)) continue;
                Long fileOffset = this.xrefTrailerResolver.getXrefTable().get(objKey);
                if (fileOffset != null && fileOffset != 0L) {
                    if (fileOffset > 0L) {
                        objToBeParsed.put(fileOffset, Collections.singletonList(obj));
                        continue;
                    }
                    fileOffset = this.xrefTrailerResolver.getXrefTable().get(new COSObjectKey(-fileOffset.longValue(), 0L));
                    if (fileOffset == null || fileOffset <= 0L) {
                        throw new IOException("Invalid object stream xref object reference for key '" + objKey + "': " + fileOffset);
                    }
                    ArrayList<COSObject> stmObjects = (ArrayList<COSObject>)objToBeParsed.get(fileOffset);
                    if (stmObjects == null) {
                        stmObjects = new ArrayList<COSObject>();
                        objToBeParsed.put(fileOffset, stmObjects);
                    }
                    stmObjects.add(obj);
                    continue;
                }
                COSObject pdfObject = this.document.getObjectFromPool(objKey);
                pdfObject.setObject(COSNull.NULL);
            }
            if (objToBeParsed.isEmpty()) break;
            for (COSObject obj : (List)objToBeParsed.remove(objToBeParsed.firstKey())) {
                COSBase parsedObj = this.parseObjectDynamically(obj, false);
                obj.setObject(parsedObj);
                this.addNewToList(toBeParsedList, parsedObj, addedObjects);
                parsedObjects.add(this.getObjectId(obj));
            }
        }
    }

    protected final COSBase parseObjectDynamically(COSObject obj, boolean requireExistingNotCompressedObj) throws IOException {
        return this.parseObjectDynamically(obj.getObjectNumber().intValue(), obj.getGenerationNumber().intValue(), requireExistingNotCompressedObj);
    }

    protected COSBase parseObjectDynamically(int objNr, int objGenNr, boolean requireExistingNotCompressedObj) throws IOException {
        COSObjectKey objKey = new COSObjectKey(objNr, objGenNr);
        COSObject pdfObject = this.document.getObjectFromPool(objKey);
        if (pdfObject.getObject() == null) {
            Long offsetOrObjstmObNr = this.xrefTrailerResolver.getXrefTable().get(objKey);
            if (requireExistingNotCompressedObj && (offsetOrObjstmObNr == null || offsetOrObjstmObNr <= 0L)) {
                throw new IOException("Object must be defined and must not be compressed object: " + objKey.getNumber() + ":" + objKey.getGeneration());
            }
            if (offsetOrObjstmObNr == null) {
                pdfObject.setObject(COSNull.NULL);
            } else if (offsetOrObjstmObNr > 0L) {
                this.setPdfSource(offsetOrObjstmObNr);
                long readObjNr = this.readObjectNumber();
                long readObjGen = this.readGenerationNumber();
                this.readPattern(OBJ_MARKER);
                if (readObjNr != objKey.getNumber() || readObjGen != objKey.getGeneration()) {
                    throw new IOException("XREF for " + objKey.getNumber() + ":" + objKey.getGeneration() + " points to wrong object: " + readObjNr + ":" + readObjGen);
                }
                this.skipSpaces();
                COSBase pb = this.parseDirObject();
                String endObjectKey = this.readString();
                if (endObjectKey.equals("stream")) {
                    COSStream stream;
                    this.pdfSource.unread(endObjectKey.getBytes("ISO-8859-1"));
                    this.pdfSource.unread(32);
                    if (pb instanceof COSDictionary) {
                        stream = this.parseCOSStream((COSDictionary)pb, this.getDocument().getScratchFile());
                        if (this.securityHandler != null) {
                            try {
                                this.securityHandler.decryptStream(stream, objNr, objGenNr);
                            }
                            catch (CryptographyException ce) {
                                throw new IOException("Error decrypting stream object " + objNr + ": " + ce.getMessage());
                            }
                        }
                    } else {
                        throw new IOException("Stream not preceded by dictionary (offset: " + offsetOrObjstmObNr + ").");
                    }
                    pb = stream;
                    this.skipSpaces();
                    endObjectKey = this.readLine();
                    if (!endObjectKey.startsWith("endobj") && endObjectKey.startsWith("endstream") && (endObjectKey = endObjectKey.substring(9).trim()).length() == 0) {
                        endObjectKey = this.readLine();
                    }
                } else if (this.securityHandler != null) {
                    this.decrypt(pb, objNr, objGenNr);
                }
                pdfObject.setObject(pb);
                if (!endObjectKey.startsWith("endobj")) {
                    if (this.isLenient) {
                        LOG.warn((Object)("Object (" + readObjNr + ":" + readObjGen + ") at offset " + offsetOrObjstmObNr + " does not end with 'endobj' but with '" + endObjectKey + "'"));
                    } else {
                        throw new IOException("Object (" + readObjNr + ":" + readObjGen + ") at offset " + offsetOrObjstmObNr + " does not end with 'endobj' but with '" + endObjectKey + "'");
                    }
                }
                this.releasePdfSourceInputStream();
            } else {
                int objstmObjNr = (int)(-offsetOrObjstmObNr.longValue());
                COSBase objstmBaseObj = this.parseObjectDynamically(objstmObjNr, 0, true);
                if (objstmBaseObj instanceof COSStream) {
                    PDFObjectStreamParser parser = new PDFObjectStreamParser((COSStream)objstmBaseObj, this.document, this.forceParsing);
                    parser.parse();
                    Set<Long> refObjNrs = this.xrefTrailerResolver.getContainedObjectNumbers(objstmObjNr);
                    for (COSObject next : parser.getObjects()) {
                        COSObjectKey stmObjKey = new COSObjectKey(next);
                        if (!refObjNrs.contains(stmObjKey.getNumber())) continue;
                        COSObject stmObj = this.document.getObjectFromPool(stmObjKey);
                        stmObj.setObject(next.getObject());
                    }
                }
            }
        }
        return pdfObject.getObject();
    }

    protected final void decryptDictionary(COSDictionary dict, long objNr, long objGenNr) throws IOException {
        if (!COSName.SIG.equals(dict.getItem(COSName.TYPE))) {
            for (Map.Entry<COSName, COSBase> entry : dict.entrySet()) {
                if (entry.getValue() instanceof COSString) {
                    this.decryptString((COSString)entry.getValue(), objNr, objGenNr);
                    continue;
                }
                if (entry.getValue() instanceof COSArray) {
                    try {
                        this.securityHandler.decryptArray((COSArray)entry.getValue(), objNr, objGenNr);
                        continue;
                    }
                    catch (CryptographyException ce) {
                        throw new IOException("Error decrypting stream object " + objNr + ": " + ce.getMessage());
                    }
                }
                if (!(entry.getValue() instanceof COSDictionary)) continue;
                this.decryptDictionary((COSDictionary)entry.getValue(), objNr, objGenNr);
            }
        }
    }

    protected final void decryptString(COSString str, long objNr, long objGenNr) throws IOException {
        try {
            this.securityHandler.decryptString(str, objNr, objGenNr);
        }
        catch (CryptographyException ce) {
            throw new IOException("Error decrypting string: " + ce.getMessage());
        }
    }

    protected final void decrypt(COSBase pb, int objNr, int objGenNr) throws IOException {
        if (pb instanceof COSString) {
            this.decryptString((COSString)pb, objNr, objGenNr);
        } else if (pb instanceof COSDictionary) {
            this.decryptDictionary((COSDictionary)pb, objNr, objGenNr);
        } else if (pb instanceof COSArray) {
            COSArray array = (COSArray)pb;
            int len = array.size();
            for (int aIdx = 0; aIdx < len; ++aIdx) {
                this.decrypt(array.get(aIdx), objNr, objGenNr);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private COSNumber getLength(COSBase lengthBaseObj) throws IOException {
        if (lengthBaseObj == null) {
            return null;
        }
        if (this.inGetLength) {
            throw new IOException("Loop while reading length from " + lengthBaseObj);
        }
        COSNumber retVal = null;
        try {
            this.inGetLength = true;
            if (lengthBaseObj instanceof COSNumber) {
                retVal = (COSNumber)lengthBaseObj;
            } else if (lengthBaseObj instanceof COSObject) {
                COSObject lengthObj = (COSObject)lengthBaseObj;
                if (lengthObj.getObject() == null) {
                    long curFileOffset = this.getPdfSourceOffset();
                    this.releasePdfSourceInputStream();
                    this.parseObjectDynamically(lengthObj, true);
                    this.setPdfSource(curFileOffset);
                    if (lengthObj.getObject() == null) {
                        throw new IOException("Length object content was not read.");
                    }
                }
                if (!(lengthObj.getObject() instanceof COSNumber)) {
                    throw new IOException("Wrong type of referenced length object " + lengthObj + ": " + lengthObj.getObject().getClass().getSimpleName());
                }
                retVal = (COSNumber)lengthObj.getObject();
            } else {
                throw new IOException("Wrong type of length object: " + lengthBaseObj.getClass().getSimpleName());
            }
            Object var7_5 = null;
            this.inGetLength = false;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            this.inGetLength = false;
            throw throwable;
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected COSStream parseCOSStream(COSDictionary dic, RandomAccess file) throws IOException {
        COSStream stream = new COSStream(dic, file);
        OutputStream out = null;
        try {
            String endStream;
            COSNumber streamLengthObj;
            this.readString();
            int whitespace = this.pdfSource.read();
            while (whitespace == 32) {
                whitespace = this.pdfSource.read();
            }
            if (whitespace == 13) {
                whitespace = this.pdfSource.read();
                if (whitespace != 10) {
                    this.pdfSource.unread(whitespace);
                }
            } else if (whitespace != 10) {
                this.pdfSource.unread(whitespace);
            }
            if ((streamLengthObj = this.getLength(dic.getItem(COSName.LENGTH))) == null) {
                if (!this.isLenient) throw new IOException("Missing length for stream.");
                LOG.warn((Object)"The stream doesn't provide any stream length, using fallback readUntilEnd");
            }
            boolean useReadUntilEnd = false;
            if (streamLengthObj != null && this.validateStreamLength(streamLengthObj.longValue())) {
                out = stream.createFilteredStream(streamLengthObj);
                long remainBytes = streamLengthObj.longValue();
                int bytesRead = 0;
                while (remainBytes > 0L) {
                    int readBytes = this.pdfSource.read(this.streamCopyBuf, 0, remainBytes > 8192L ? 8192 : (int)remainBytes);
                    if (readBytes <= 0) {
                        useReadUntilEnd = true;
                        out.close();
                        this.pdfSource.unread(bytesRead);
                        break;
                    }
                    out.write(this.streamCopyBuf, 0, readBytes);
                    remainBytes -= (long)readBytes;
                    bytesRead += readBytes;
                }
            } else {
                useReadUntilEnd = true;
            }
            if (useReadUntilEnd) {
                out = stream.createFilteredStream();
                this.readUntilEndStream(new EndstreamOutputStream(out));
            }
            if ((endStream = this.readString()).equals("endobj") && this.isLenient) {
                LOG.warn((Object)("stream ends with 'endobj' instead of 'endstream' at offset " + this.pdfSource.getOffset()));
                this.pdfSource.unread("endobj".getBytes("ISO-8859-1"));
            } else if (endStream.length() > 9 && this.isLenient && endStream.substring(0, 9).equals("endstream")) {
                LOG.warn((Object)("stream ends with '" + endStream + "' instead of 'endstream' at offset " + this.pdfSource.getOffset()));
                this.pdfSource.unread(endStream.substring(9).getBytes("ISO-8859-1"));
            } else if (!endStream.equals("endstream")) {
                throw new IOException("Error reading stream, expected='endstream' actual='" + endStream + "' at offset " + this.pdfSource.getOffset());
            }
            Object var13_12 = null;
            if (out == null) return stream;
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            if (out == null) throw throwable;
            out.close();
            throw throwable;
        }
        out.close();
        return stream;
    }

    private boolean validateStreamLength(long streamLength) throws IOException {
        boolean streamLengthIsValid = true;
        long originOffset = this.pdfSource.getOffset();
        long expectedEndOfStream = originOffset + streamLength;
        if (expectedEndOfStream > this.fileLen) {
            streamLengthIsValid = false;
            LOG.error((Object)"The end of the stream is out of range, using workaround to read the stream");
            LOG.error((Object)("Stream start offset: " + originOffset));
            LOG.error((Object)("Expected endofstream offset: " + expectedEndOfStream));
        } else {
            this.pdfSource.seek(expectedEndOfStream);
            this.skipSpaces();
            if (!this.checkBytesAtOffset("endstream".getBytes("ISO-8859-1"))) {
                streamLengthIsValid = false;
                LOG.error((Object)"The end of the stream doesn't point to the correct offset, using workaround to read the stream");
                LOG.error((Object)("Stream start offset: " + originOffset));
                LOG.error((Object)("Expected endofstream offset: " + expectedEndOfStream));
            }
            this.pdfSource.seek(originOffset);
        }
        return streamLengthIsValid;
    }

    private long checkXRefOffset(long startXRefOffset) throws IOException {
        int nextValue;
        if (!this.isLenient) {
            return startXRefOffset;
        }
        this.setPdfSource(startXRefOffset - 1L);
        int previous = this.pdfSource.read();
        if (this.pdfSource.peek() == 120 && this.checkBytesAtOffset(XREF_TABLE)) {
            return startXRefOffset;
        }
        if (this.isWhitespace(previous) && (nextValue = this.pdfSource.peek()) > 47 && nextValue < 58) {
            try {
                this.readObjectNumber();
                this.readGenerationNumber();
                this.readPattern(OBJ_MARKER);
                this.setPdfSource(startXRefOffset);
                return startXRefOffset;
            }
            catch (IOException exception) {
                this.pdfSource.seek(startXRefOffset);
            }
        }
        return this.calculateXRefFixedOffset(startXRefOffset);
    }

    private boolean checkBytesAtOffset(byte[] string) throws IOException {
        boolean bytesMatching = false;
        if (this.pdfSource.peek() == string[0]) {
            int numberOfBytes;
            int readMore;
            int length = string.length;
            byte[] bytesRead = new byte[length];
            for (numberOfBytes = this.pdfSource.read(bytesRead, 0, length); numberOfBytes < length && (readMore = this.pdfSource.read(bytesRead, numberOfBytes, length - numberOfBytes)) >= 0; numberOfBytes += readMore) {
            }
            if (Arrays.equals(string, bytesRead)) {
                bytesMatching = true;
            }
            this.pdfSource.unread(bytesRead, 0, numberOfBytes);
        }
        return bytesMatching;
    }

    private long calculateXRefFixedOffset(long objectOffset) throws IOException {
        if (objectOffset < 0L) {
            LOG.error((Object)("Invalid object offset " + objectOffset + " when searching for a xref table/stream"));
            return 0L;
        }
        long newOffset = this.bfSearchForXRef(objectOffset);
        if (newOffset > -1L) {
            LOG.debug((Object)("Fixed reference for xref table/stream " + objectOffset + " -> " + newOffset));
            return newOffset;
        }
        LOG.error((Object)("Can't find the object axref table/stream at offset " + objectOffset));
        return 0L;
    }

    private void checkXrefOffsets() throws IOException {
        if (!this.isLenient) {
            return;
        }
        Map<COSObjectKey, Long> xrefOffset = this.xrefTrailerResolver.getXrefTable();
        if (xrefOffset != null) {
            for (COSObjectKey objectKey : xrefOffset.keySet()) {
                long objectGen;
                long objectNr;
                String objectString;
                Long objectOffset = xrefOffset.get(objectKey);
                if (objectOffset == null || objectOffset < 0L || this.checkObjectId(objectString = this.createObjectString(objectNr = objectKey.getNumber(), objectGen = objectKey.getGeneration()), objectOffset)) continue;
                long newOffset = this.bfSearchForObject(objectString);
                if (newOffset > -1L) {
                    xrefOffset.put(objectKey, newOffset);
                    LOG.debug((Object)("Fixed reference for object " + objectNr + " " + objectGen + " " + objectOffset + " -> " + newOffset));
                    continue;
                }
                LOG.error((Object)("Can't find the object " + objectNr + " " + objectGen + " (origin offset " + objectOffset + ")"));
            }
        }
    }

    private boolean checkObjectId(String objectString, long offset) throws IOException {
        boolean objectFound = false;
        long originOffset = this.pdfSource.getOffset();
        this.pdfSource.seek(offset);
        objectFound = this.checkBytesAtOffset(objectString.getBytes("ISO-8859-1"));
        this.pdfSource.seek(originOffset);
        return objectFound;
    }

    private String createObjectString(long objectID, long genID) {
        return Long.toString(objectID) + " " + Long.toString(genID) + " obj";
    }

    private long bfSearchForObject(String objectString) throws IOException {
        long newOffset = -1L;
        this.bfSearchForObjects();
        if (this.bfSearchObjectOffsets.containsKey(objectString)) {
            newOffset = this.bfSearchObjectOffsets.get(objectString);
        }
        return newOffset;
    }

    private void bfSearchForObjects() throws IOException {
        if (this.bfSearchObjectOffsets == null) {
            this.bfSearchObjectOffsets = new HashMap();
            this.bfSearchCOSObjectKeyOffsets = new HashMap();
            long originOffset = this.pdfSource.getOffset();
            long currentOffset = 6L;
            String objString = " obj";
            byte[] string = objString.getBytes("ISO-8859-1");
            do {
                this.pdfSource.seek(currentOffset);
                if (this.checkBytesAtOffset(string)) {
                    long tempOffset = currentOffset - 1L;
                    this.pdfSource.seek(tempOffset);
                    int genID = this.pdfSource.peek();
                    if (genID > 47 && genID < 58) {
                        genID -= 48;
                        this.pdfSource.seek(--tempOffset);
                        if (this.pdfSource.peek() == 32) {
                            while (tempOffset > 6L && this.pdfSource.peek() == 32) {
                                this.pdfSource.seek(--tempOffset);
                            }
                            int length = 0;
                            while (tempOffset > 6L && this.pdfSource.peek() > 47 && this.pdfSource.peek() < 58) {
                                this.pdfSource.seek(--tempOffset);
                                ++length;
                            }
                            if (length > 0) {
                                this.pdfSource.read();
                                byte[] objIDBytes = this.pdfSource.readFully(length);
                                String objIdString = new String(objIDBytes, 0, objIDBytes.length, "ISO-8859-1");
                                Long objectID = null;
                                try {
                                    objectID = Long.valueOf(objIdString);
                                }
                                catch (NumberFormatException excpetion) {
                                    objectID = null;
                                }
                                if (objectID != null) {
                                    this.bfSearchObjectOffsets.put(this.createObjectString(objectID, genID), ++tempOffset);
                                    this.bfSearchCOSObjectKeyOffsets.put(new COSObjectKey(objectID, genID), tempOffset);
                                }
                            }
                        }
                    }
                }
                ++currentOffset;
            } while (!this.pdfSource.isEOF());
            this.pdfSource.seek(originOffset);
        }
    }

    private long bfSearchForXRef(long xrefOffset) throws IOException {
        long newOffset = -1L;
        this.bfSearchForXRefs();
        if (this.bfSearchXRefOffsets != null) {
            long currentDifference = -1L;
            int currentOffsetIndex = -1;
            int numberOfOffsets = this.bfSearchXRefOffsets.size();
            for (int i = 0; i < numberOfOffsets; ++i) {
                long newDifference = xrefOffset - this.bfSearchXRefOffsets.get(i);
                if (currentDifference != -1L && Math.abs(currentDifference) <= Math.abs(newDifference)) continue;
                currentDifference = newDifference;
                currentOffsetIndex = i;
            }
            if (currentOffsetIndex > -1) {
                newOffset = this.bfSearchXRefOffsets.remove(currentOffsetIndex);
            }
        }
        return newOffset;
    }

    private void bfSearchForXRefs() throws IOException {
        if (this.bfSearchXRefOffsets == null) {
            this.bfSearchXRefOffsets = new Vector();
            long originOffset = this.pdfSource.getOffset();
            this.pdfSource.seek(6L);
            while (!this.pdfSource.isEOF()) {
                if (this.checkBytesAtOffset(XREF_TABLE)) {
                    long newOffset = this.pdfSource.getOffset();
                    this.pdfSource.seek(newOffset - 1L);
                    if (this.isWhitespace()) {
                        this.bfSearchXRefOffsets.add(newOffset);
                    }
                    this.pdfSource.seek(newOffset + 4L);
                }
                this.pdfSource.read();
            }
            this.pdfSource.seek(6L);
            String objString = " obj";
            byte[] string = objString.getBytes("ISO-8859-1");
            while (!this.pdfSource.isEOF()) {
                if (this.checkBytesAtOffset(XREF_STREAM)) {
                    long xrefOffset;
                    long newOffset = -1L;
                    long currentOffset = xrefOffset = this.pdfSource.getOffset();
                    boolean objFound = false;
                    block2: for (int i = 1; i < 30 && !objFound; ++i) {
                        currentOffset = xrefOffset - (long)(i * 10);
                        if (currentOffset <= 0L) continue;
                        this.pdfSource.seek(currentOffset);
                        for (int j = 0; j < 10; ++j) {
                            if (this.checkBytesAtOffset(string)) {
                                long tempOffset = currentOffset - 1L;
                                this.pdfSource.seek(tempOffset);
                                int genID = this.pdfSource.peek();
                                if (genID > 47 && genID < 58) {
                                    genID -= 48;
                                    this.pdfSource.seek(--tempOffset);
                                    if (this.pdfSource.peek() == 32) {
                                        int length = 0;
                                        this.pdfSource.seek(--tempOffset);
                                        while (tempOffset > 6L && this.pdfSource.peek() > 47 && this.pdfSource.peek() < 58) {
                                            this.pdfSource.seek(--tempOffset);
                                            ++length;
                                        }
                                        if (length > 0) {
                                            this.pdfSource.read();
                                            newOffset = this.pdfSource.getOffset();
                                        }
                                    }
                                }
                                LOG.debug((Object)("Fixed reference for xref stream " + xrefOffset + " -> " + newOffset));
                                objFound = true;
                                continue block2;
                            }
                            ++currentOffset;
                            this.pdfSource.read();
                        }
                    }
                    if (newOffset > -1L) {
                        this.bfSearchXRefOffsets.add(newOffset);
                    }
                    this.pdfSource.seek(xrefOffset + 5L);
                }
                this.pdfSource.read();
            }
            this.pdfSource.seek(originOffset);
        }
    }
}

