@REM duometer launcher script
@REM
@REM Environment:
@REM JAVA_HOME - location of a JDK home dir (optional if java on path)
@REM CFG_OPTS  - JVM options (optional)
@REM Configuration:
@REM DUOMETER_config.txt found in the DUOMETER_HOME.
@setlocal enabledelayedexpansion

@echo off
if "%DUOMETER_HOME%"=="" set "DUOMETER_HOME=%~dp0\\.."
set ERROR_CODE=0

set "APP_LIB_DIR=%DUOMETER_HOME%\lib\"

rem Detect if we were double clicked, although theoretically A user could
rem manually run cmd /c
for %%x in (%cmdcmdline%) do if %%~x==/c set DOUBLECLICKED=1

rem FIRST we load the config file of extra options.
set "CFG_FILE=%DUOMETER_HOME%\DUOMETER_config.txt"
set CFG_OPTS=
if exist %CFG_FILE% (
  FOR /F "tokens=* eol=# usebackq delims=" %%i IN ("%CFG_FILE%") DO (
    set DO_NOT_REUSE_ME=%%i
    rem ZOMG (Part #2) WE use !! here to delay the expansion of
    rem CFG_OPTS, otherwise it remains "" for this loop.
    set CFG_OPTS=!CFG_OPTS! !DO_NOT_REUSE_ME!
  )
)

rem We use the value of the JAVACMD environment variable if defined
set _JAVACMD=%JAVACMD%

if "%_JAVACMD%"=="" (
  if not "%JAVA_HOME%"=="" (
    if exist "%JAVA_HOME%\bin\java.exe" set "_JAVACMD=%JAVA_HOME%\bin\java.exe"
  )
)

if "%_JAVACMD%"=="" set _JAVACMD=java

rem Detect if this java is ok to use.
for /F %%j in ('"%_JAVACMD%" -version  2^>^&1') do (
  if %%~j==Java set JAVAINSTALLED=1
)

rem BAT has no logical or, so we do it OLD SCHOOL! Oppan Redmond Style
set JAVAOK=true
if not defined JAVAINSTALLED set JAVAOK=false

if "%JAVAOK%"=="false" (
  echo.
  echo A Java JDK is not installed or can't be found.
  if not "%JAVA_HOME%"=="" (
    echo JAVA_HOME = "%JAVA_HOME%"
  )
  echo.
  echo Please go to
  echo   http://www.oracle.com/technetwork/java/javase/downloads/index.html
  echo and download a valid Java JDK and install before running duometer.
  echo.
  echo If you think this message is in error, please check
  echo your environment variables to see if "java.exe" and "javac.exe" are
  echo available via JAVA_HOME or PATH.
  echo.
  if defined DOUBLECLICKED pause
  exit /B 1
)


rem We use the value of the JAVA_OPTS environment variable if defined, rather than the config.
set _JAVA_OPTS=%JAVA_OPTS%
if "%_JAVA_OPTS%"=="" set _JAVA_OPTS=%CFG_OPTS%

rem We keep in _JAVA_PARAMS all -J-prefixed and -D-prefixed arguments
rem "-J" is stripped, "-D" is left as is, and everything is appended to JAVA_OPTS
set _JAVA_PARAMS=

:param_beforeloop
if [%1]==[] goto param_afterloop
set _TEST_PARAM=%~1

rem ignore arguments that do not start with '-'
if not "%_TEST_PARAM:~0,1%"=="-" (
  shift
  goto param_beforeloop
)

set _TEST_PARAM=%~1
if "%_TEST_PARAM:~0,2%"=="-J" (
  rem strip -J prefix
  set _TEST_PARAM=%_TEST_PARAM:~2%
)

if "%_TEST_PARAM:~0,2%"=="-D" (
  rem test if this was double-quoted property "-Dprop=42"
  for /F "delims== tokens=1-2" %%G in ("%_TEST_PARAM%") DO (
    if not "%%G" == "%_TEST_PARAM%" (
      rem double quoted: "-Dprop=42" -> -Dprop="42"
      set _JAVA_PARAMS=%%G="%%H"
    ) else if [%2] neq [] (
      rem it was a normal property: -Dprop=42 or -Drop="42"
      set _JAVA_PARAMS=%_TEST_PARAM%=%2
      shift
    )
  )
) else (
  rem a JVM property, we just append it
  set _JAVA_PARAMS=%_TEST_PARAM%
)

:param_loop
shift

if [%1]==[] goto param_afterloop
set _TEST_PARAM=%~1

rem ignore arguments that do not start with '-'
if not "%_TEST_PARAM:~0,1%"=="-" goto param_loop

set _TEST_PARAM=%~1
if "%_TEST_PARAM:~0,2%"=="-J" (
  rem strip -J prefix
  set _TEST_PARAM=%_TEST_PARAM:~2%
)

if "%_TEST_PARAM:~0,2%"=="-D" (
  rem test if this was double-quoted property "-Dprop=42"
  for /F "delims== tokens=1-2" %%G in ("%_TEST_PARAM%") DO (
    if not "%%G" == "%_TEST_PARAM%" (
      rem double quoted: "-Dprop=42" -> -Dprop="42"
      set _JAVA_PARAMS=%_JAVA_PARAMS% %%G="%%H"
    ) else if [%2] neq [] (
      rem it was a normal property: -Dprop=42 or -Drop="42"
      set _JAVA_PARAMS=%_JAVA_PARAMS% %_TEST_PARAM%=%2
      shift
    )
  )
) else (
  rem a JVM property, we just append it
  set _JAVA_PARAMS=%_JAVA_PARAMS% %_TEST_PARAM%
)
goto param_loop
:param_afterloop

set _JAVA_OPTS=%_JAVA_OPTS% %_JAVA_PARAMS%
:run
 
set "APP_CLASSPATH=%APP_LIB_DIR%\com.pawelmandera.duometer-0.1.3.jar;%APP_LIB_DIR%\org.scala-lang.scala-library-2.11.4.jar;%APP_LIB_DIR%\com.github.scopt.scopt_2.11-3.3.0.jar;%APP_LIB_DIR%\org.apache.tika.tika-parsers-1.8.jar;%APP_LIB_DIR%\org.apache.tika.tika-core-1.8.jar;%APP_LIB_DIR%\org.gagravarr.vorbis-java-tika-0.6.jar;%APP_LIB_DIR%\net.sourceforge.jmatio.jmatio-1.0.jar;%APP_LIB_DIR%\org.apache.james.apache-mime4j-core-0.7.2.jar;%APP_LIB_DIR%\org.apache.james.apache-mime4j-dom-0.7.2.jar;%APP_LIB_DIR%\org.apache.commons.commons-compress-1.9.jar;%APP_LIB_DIR%\org.tukaani.xz-1.5.jar;%APP_LIB_DIR%\org.apache.pdfbox.pdfbox-1.8.9.jar;%APP_LIB_DIR%\org.apache.pdfbox.fontbox-1.8.9.jar;%APP_LIB_DIR%\org.apache.pdfbox.jempbox-1.8.9.jar;%APP_LIB_DIR%\org.bouncycastle.bcmail-jdk15on-1.52.jar;%APP_LIB_DIR%\org.bouncycastle.bcprov-jdk15on-1.52.jar;%APP_LIB_DIR%\org.bouncycastle.bcpkix-jdk15on-1.52.jar;%APP_LIB_DIR%\org.apache.poi.poi-3.12-beta1.jar;%APP_LIB_DIR%\org.apache.poi.poi-scratchpad-3.12-beta1.jar;%APP_LIB_DIR%\org.apache.poi.poi-ooxml-3.12-beta1.jar;%APP_LIB_DIR%\org.apache.poi.poi-ooxml-schemas-3.12-beta1.jar;%APP_LIB_DIR%\org.apache.xmlbeans.xmlbeans-2.6.0.jar;%APP_LIB_DIR%\org.ccil.cowan.tagsoup.tagsoup-1.2.1.jar;%APP_LIB_DIR%\org.ow2.asm.asm-debug-all-4.1.jar;%APP_LIB_DIR%\com.googlecode.mp4parser.isoparser-1.0.2.jar;%APP_LIB_DIR%\org.aspectj.aspectjrt-1.8.0.jar;%APP_LIB_DIR%\com.drewnoakes.metadata-extractor-2.8.0.jar;%APP_LIB_DIR%\com.adobe.xmp.xmpcore-5.1.2.jar;%APP_LIB_DIR%\de.l3s.boilerpipe.boilerpipe-1.1.0.jar;%APP_LIB_DIR%\rome.rome-1.0.jar;%APP_LIB_DIR%\jdom.jdom-1.0.jar;%APP_LIB_DIR%\org.gagravarr.vorbis-java-core-0.6.jar;%APP_LIB_DIR%\org.xerial.sqlite-jdbc-3.8.6.jar;%APP_LIB_DIR%\com.googlecode.juniversalchardet.juniversalchardet-1.0.3.jar;%APP_LIB_DIR%\org.codelibs.jhighlight-1.0.2.jar;%APP_LIB_DIR%\com.pff.java-libpst-0.8.1.jar;%APP_LIB_DIR%\com.github.junrar.junrar-0.7.jar;%APP_LIB_DIR%\commons-logging.commons-logging-api-1.1.jar;%APP_LIB_DIR%\org.apache.commons.commons-vfs2-2.0.jar;%APP_LIB_DIR%\org.apache.maven.scm.maven-scm-api-1.4.jar;%APP_LIB_DIR%\org.codehaus.plexus.plexus-utils-1.5.6.jar;%APP_LIB_DIR%\org.apache.maven.scm.maven-scm-provider-svnexe-1.4.jar;%APP_LIB_DIR%\org.apache.maven.scm.maven-scm-provider-svn-commons-1.4.jar;%APP_LIB_DIR%\regexp.regexp-1.3.jar;%APP_LIB_DIR%\edu.ucar.netcdf4-4.5.5.jar;%APP_LIB_DIR%\net.jcip.jcip-annotations-1.0.jar;%APP_LIB_DIR%\net.java.dev.jna.jna-4.1.0.jar;%APP_LIB_DIR%\org.slf4j.slf4j-api-1.7.7.jar;%APP_LIB_DIR%\edu.ucar.grib-4.5.5.jar;%APP_LIB_DIR%\com.google.protobuf.protobuf-java-2.5.0.jar;%APP_LIB_DIR%\org.jdom.jdom2-2.0.4.jar;%APP_LIB_DIR%\org.jsoup.jsoup-1.7.2.jar;%APP_LIB_DIR%\edu.ucar.jj2000-5.2.jar;%APP_LIB_DIR%\org.itadaki.bzip2-0.9.1.jar;%APP_LIB_DIR%\edu.ucar.cdm-4.5.5.jar;%APP_LIB_DIR%\edu.ucar.udunits-4.5.5.jar;%APP_LIB_DIR%\joda-time.joda-time-2.2.jar;%APP_LIB_DIR%\edu.ucar.httpservices-4.5.5.jar;%APP_LIB_DIR%\org.apache.httpcomponents.httpclient-4.2.6.jar;%APP_LIB_DIR%\org.apache.httpcomponents.httpcore-4.2.5.jar;%APP_LIB_DIR%\commons-codec.commons-codec-1.6.jar;%APP_LIB_DIR%\org.apache.httpcomponents.httpmime-4.2.6.jar;%APP_LIB_DIR%\org.quartz-scheduler.quartz-2.2.0.jar;%APP_LIB_DIR%\c3p0.c3p0-0.9.1.1.jar;%APP_LIB_DIR%\net.sf.ehcache.ehcache-core-2.6.2.jar;%APP_LIB_DIR%\com.beust.jcommander-1.35.jar;%APP_LIB_DIR%\com.google.guava.guava-10.0.1.jar;%APP_LIB_DIR%\com.google.code.findbugs.jsr305-1.3.9.jar;%APP_LIB_DIR%\org.apache.commons.commons-csv-1.0.jar"
set "APP_MAIN_CLASS=com.pawelmandera.main.MinHashMain"

rem Call the application and pass all arguments unchanged.
"%_JAVACMD%" %_JAVA_OPTS% %DUOMETER_OPTS% -cp "%APP_CLASSPATH%" %APP_MAIN_CLASS% %*
if ERRORLEVEL 1 goto error
goto end

:error
set ERROR_CODE=1

:end

@endlocal

exit /B %ERROR_CODE%
